/**********
* File: CDGL_IDirect3DQuery9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DQuery9. 
					 This class is the concrete implementation of IDirect3DQuery9 interface. The IDirect3DQuery9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 17Mar05

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DQUERY9_H__
#define __CDGL_IDIRECT3DQUERY9_H__

#include <Carbon/Carbon.h>
#include "d3d9.h"

class CDGL_IDirect3DQuery9 : public IDirect3DQuery9
{

	public:
		
		CDGL_IDirect3DQuery9(IDirect3DDevice9 *in_pDevice,D3DQUERYTYPE in_QueyType);
		~CDGL_IDirect3DQuery9();
		
		 /*** IUnknown methods ***/
		HRESULT QueryInterface( REFIID riid, void** ppvObj);
		ULONG AddRef();
		ULONG Release();

		/*** IDirect3DQuery9 methods ***/
		HRESULT GetDevice( IDirect3DDevice9** ppDevice);
		D3DQUERYTYPE GetType();
		DWORD GetDataSize();
		HRESULT Issue( DWORD dwIssueFlags);
		HRESULT GetData( void* pData,DWORD dwSize,DWORD dwGetDataFlags);
	
	private:
	
		//! Member variables
		IDirect3DDevice9 *		m_pDevice;
		int						m_lRefCount;
		D3DQUERYTYPE			m_QueryType;
};


#endif //__CDGL_IDIRECT3DQUERY9_H__

